/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GhazbanOgreEffect
extends OneShotEffect {
    GhazbanOgreEffect() {
        super(Outcome.GainControl);
        this.staticText = "the player with the most life gains control of {this}";
    }

    private GhazbanOgreEffect(GhazbanOgreEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhazbanOgreEffect copy() {
        return new GhazbanOgreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (sourcePermanent != null) {
                Player newController = null;
                int lowLife = Integer.MIN_VALUE;
                boolean tie = false;
                for (UUID playerID : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    Player player = game.getPlayer(playerID);
                    if (player == null) continue;
                    if (player.getLife() > lowLife) {
                        lowLife = player.getLife();
                        newController = player;
                        tie = false;
                        continue;
                    }
                    if (player.getLife() != lowLife) continue;
                    tie = true;
                }
                if (!controller.equals(newController) && !tie && newController != null) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, newController.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

