/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GhostVacuumEffect
extends OneShotEffect {
    GhostVacuumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put each creature card exiled with {this} onto the battlefield under your control with a flying counter on it. Each of them is a 1/1 Spirit in addition to its other types.";
    }

    private GhostVacuumEffect(GhostVacuumEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        CardsImpl creatureCards = new CardsImpl(exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        Counters countersToAdd = new Counters(new Counter[0]);
        countersToAdd.addCounter(CounterType.FLYING.createInstance());
        for (Card card : creatureCards.getCards(game)) {
            game.setEnterWithCounters(card.getId(), countersToAdd.copy());
        }
        player.moveCards((Cards)creatureCards, Zone.BATTLEFIELD, source, game);
        creatureCards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(permanent -> {
            SetBasePowerToughnessTargetEffect effect = new SetBasePowerToughnessTargetEffect(1, 1, Duration.EndOfGame);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new AddCreatureTypeAdditionEffect(SubType.SPIRIT, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        });
        return true;
    }

    public GhostVacuumEffect copy() {
        return new GhostVacuumEffect(this);
    }
}

