/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DecayedAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.g.GhoulsNightOutTypeChangingEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class GhoulsNightOutEffect
extends OneShotEffect {
    GhoulsNightOutEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "For each player, choose a creature card in that player's graveyard. Put those cards onto the battlefield under your control. They're black Zombies in addition to their other colors and types and they gain decayed";
    }

    private GhoulsNightOutEffect(GhoulsNightOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhoulsNightOutEffect copy() {
        return new GhoulsNightOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            HashSet<Card> cardsToBattlefield = new HashSet<Card>();
            for (UUID playerId : game.getState().getPlayersInRange(controllerId, game)) {
                Card card2;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                boolean creatureInGraveyard = false;
                for (UUID cardId : player.getGraveyard()) {
                    card2 = game.getCard(cardId);
                    if (card2 == null || !card2.isCreature(game)) continue;
                    creatureInGraveyard = true;
                    break;
                }
                if (!creatureInGraveyard) continue;
                FilterCreatureCard filter = new FilterCreatureCard("creature card in " + player.getName() + "'s graveyard");
                TargetCard target = new TargetCard(Zone.GRAVEYARD, (FilterCard)filter);
                target.withNotTarget(true);
                controller.chooseTarget(controllerId.equals(playerId) ? Outcome.Benefit : Outcome.Detriment, (Cards)player.getGraveyard(), target, source, game);
                card2 = game.getCard(target.getFirstTarget());
                if (card2 == null) continue;
                cardsToBattlefield.add(card2);
            }
            if (!cardsToBattlefield.isEmpty()) {
                controller.moveCards(cardsToBattlefield, Zone.BATTLEFIELD, source, game);
                cardsToBattlefield.removeIf(card -> game.getState().getZone(card.getId()) != Zone.BATTLEFIELD);
                if (!cardsToBattlefield.isEmpty()) {
                    game.addEffect(new GhoulsNightOutTypeChangingEffect().setTargetPointer((TargetPointer)new FixedTargets(cardsToBattlefield, game)), source);
                    game.addEffect(new GainAbilityTargetEffect((Ability)new DecayedAbility(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets(cardsToBattlefield, game)), source);
                    return true;
                }
            }
        }
        return false;
    }
}

