/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextDrawStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.g.GiantOysterLeaveUntapDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GiantOysterCreateDelayedTriggerEffects
extends OneShotEffect {
    GiantOysterCreateDelayedTriggerEffects() {
        super(Outcome.Detriment);
        this.staticText = "at the beginning of each of your draw steps, put a -1/-1 counter on that creature. When {this} leaves the battlefield or becomes untapped, remove all -1/-1 counters from the creature.";
    }

    private GiantOysterCreateDelayedTriggerEffects(GiantOysterCreateDelayedTriggerEffects effect) {
        super((OneShotEffect)effect);
    }

    public GiantOysterCreateDelayedTriggerEffects copy() {
        return new GiantOysterCreateDelayedTriggerEffects(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent oyster = game.getPermanent(source.getSourceId());
        Permanent tappedCreature = game.getPermanent(source.getFirstTarget());
        if (controller == null || oyster == null || tappedCreature == null) {
            return false;
        }
        AddCountersTargetEffect addCountersEffect = new AddCountersTargetEffect(CounterType.M1M1.createInstance(1));
        addCountersEffect.setTargetPointer((TargetPointer)new FixedTarget(tappedCreature, game));
        AtTheBeginOfYourNextDrawStepDelayedTriggeredAbility drawStepAbility = new AtTheBeginOfYourNextDrawStepDelayedTriggeredAbility((Effect)addCountersEffect, Duration.Custom, false);
        drawStepAbility.setControllerId(source.getControllerId());
        UUID drawStepAbilityUUID = game.addDelayedTriggeredAbility((DelayedTriggeredAbility)drawStepAbility, source);
        GiantOysterLeaveUntapDelayedTriggeredAbility leaveUntapDelayedTriggeredAbility = new GiantOysterLeaveUntapDelayedTriggeredAbility(drawStepAbilityUUID);
        ((Effect)leaveUntapDelayedTriggeredAbility.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(tappedCreature, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)leaveUntapDelayedTriggeredAbility, source);
        return true;
    }
}

