/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;

class GiantsSkewerTriggeredAbility
extends TriggeredAbilityImpl {
    GiantsSkewerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new FoodToken()));
    }

    private GiantsSkewerTriggeredAbility(GiantsSkewerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GiantsSkewerTriggeredAbility copy() {
        return new GiantsSkewerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a creature, create a Food token.";
    }
}

