/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GideonExileAllOtherPermanentsEffect
extends OneShotEffect {
    GideonExileAllOtherPermanentsEffect() {
        super(Outcome.Exile);
        this.staticText = "exile all other permanents";
    }

    private GideonExileAllOtherPermanentsEffect(GideonExileAllOtherPermanentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GideonExileAllOtherPermanentsEffect copy() {
        return new GideonExileAllOtherPermanentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(source.getSourceObject(game), game);
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT, source.getControllerId(), game).stream().filter(Objects::nonNull).filter(permanent -> !mor.refersTo((MageObject)permanent, game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

