/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GideonsSacrificeEffectReplacementEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    GideonsSacrificeEffectReplacementEffect(MageObjectReference mor) {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.mor = mor;
    }

    private GideonsSacrificeEffectReplacementEffect(GideonsSacrificeEffectReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent targetPermanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER && event.getPlayerId().equals(source.getControllerId())) {
            return true;
        }
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (targetPermanent = game.getPermanent(event.getTargetId())) != null && targetPermanent.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent permanent = this.mor.getPermanent(game);
        if (permanent == null) {
            return false;
        }
        Permanent targetPermanent = game.getPermanent(event.getTargetId());
        StringBuilder message = new StringBuilder();
        message.append(permanent.getName()).append(": gets ");
        message.append(damageEvent.getAmount()).append(" damage redirected from ");
        if (targetPermanent != null) {
            message.append(targetPermanent.getName());
        } else {
            Player targetPlayer = game.getPlayer(event.getTargetId());
            if (targetPlayer != null) {
                message.append(targetPlayer.getLogName());
            } else {
                message.append("unknown");
            }
        }
        game.informPlayers(message.toString());
        permanent.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
        return true;
    }

    public GideonsSacrificeEffectReplacementEffect copy() {
        return new GideonsSacrificeEffectReplacementEffect(this);
    }
}

