/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.g.GilgameshMasterAtArmsAttachEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class GilgameshMasterAtArmsLookEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Equipment cards");

    GilgameshMasterAtArmsLookEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may put any number of Equipment cards from among them onto the battlefield. Put the rest on the bottom of your library in a random order. When you put one or more Equipment onto the battlefield this way, you may attach one of them to a Samurai you control";
    }

    private GilgameshMasterAtArmsLookEffect(GilgameshMasterAtArmsLookEffect effect) {
        super((OneShotEffect)effect);
    }

    public GilgameshMasterAtArmsLookEffect copy() {
        return new GilgameshMasterAtArmsLookEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toPlay = new CardsImpl((Collection)target.getTargets());
        player.moveCards((Cards)toPlay, Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        Set<Permanent> permanents = toPlay.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!permanents.isEmpty()) {
            game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new GilgameshMasterAtArmsAttachEffect(permanents, game), false), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.EQUIPMENT.getPredicate());
    }
}

