/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DifferentlyNamedPermanentCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GremlinArtifactToken;

class GimbalGremlinProdigyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent("artifact tokens you control");
    private static final DifferentlyNamedPermanentCount xValue;

    static final Hint getHint() {
        return xValue.getHint();
    }

    GimbalGremlinProdigyEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 0/0 red Gremlin artifact creature token. Put X +1/+1 counters on it, where X is the number of differently named artifact tokens you control";
    }

    private GimbalGremlinProdigyEffect(GimbalGremlinProdigyEffect effect) {
        super((OneShotEffect)effect);
    }

    public GimbalGremlinProdigyEffect copy() {
        return new GimbalGremlinProdigyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        GremlinArtifactToken token = new GremlinArtifactToken();
        token.putOntoBattlefield(1, game, source);
        int amount = xValue.calculate(game, source, (Effect)this);
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        xValue = new DifferentlyNamedPermanentCount(filter);
    }
}

