/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GixYawgmothPraetorExileEffect
extends OneShotEffect {
    GixYawgmothPraetorExileEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top X cards of target opponent's library. You may play lands and cast spells from among cards exiled this way without paying their mana costs.";
    }

    private GixYawgmothPraetorExileEffect(GixYawgmothPraetorExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public GixYawgmothPraetorExileEffect copy() {
        return new GixYawgmothPraetorExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        Set toExile = opponent.getLibrary().getTopCards(game, xValue);
        controller.moveCards(toExile, Zone.EXILED, source, game);
        game.processAction();
        CardsImpl cards = new CardsImpl(toExile);
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD, (int)Integer.MAX_VALUE, null, (boolean)true);
        return true;
    }
}

