/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.g.GixsCommandCounterEffect;
import mage.cards.g.GixsCommandReturnEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.GreatestPowerControlledPredicate;

public final class GixsCommand
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("each creature with power 2 or less");
    private static final FilterCreaturePermanent filter2 = new FilterCreaturePermanent("creature with the highest power among creatures they control");

    public GixsCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{B}{B}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new GixsCommandCounterEffect());
        this.getSpellAbility().addMode(new Mode((Effect)new DestroyAllEffect((FilterPermanent)filter).setText("Destroy each creature with power 2 or less")));
        this.getSpellAbility().addMode(new Mode((Effect)new GixsCommandReturnEffect()));
        this.getSpellAbility().addMode(new Mode((Effect)new SacrificeOpponentsEffect((FilterPermanent)filter2)));
    }

    private GixsCommand(GixsCommand card) {
        super((CardImpl)card);
    }

    public GixsCommand copy() {
        return new GixsCommand(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
        filter2.add((ObjectSourcePlayerPredicate)GreatestPowerControlledPredicate.instance);
    }
}

