/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GlacialGraspEffect
extends OneShotEffect {
    GlacialGraspEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap target creature. Its controller mills two cards. That creature doesn't untap during its controller's next untap step.";
    }

    private GlacialGraspEffect(GlacialGraspEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlacialGraspEffect copy() {
        return new GlacialGraspEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.tap(source, game);
        game.addEffect((ContinuousEffect)new DontUntapInControllersNextUntapStepTargetEffect(), source);
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(2, source, game);
        return true;
    }
}

