/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceUnlessPaysEffect;
import mage.abilities.mana.WhiteManaAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class Glaciers
extends CardImpl {
    public Glaciers(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{U}");
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility((Effect)new SacrificeSourceUnlessPaysEffect((Cost)new ManaCostsImpl("{W}{U}"))));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GlaciersEffect()));
    }

    private Glaciers(Glaciers card) {
        super((CardImpl)card);
    }

    public Glaciers copy() {
        return new Glaciers(this);
    }

    static class GlaciersEffect
    extends ContinuousEffectImpl {
        GlaciersEffect() {
            super(Duration.WhileOnBattlefield, Outcome.Detriment);
            this.staticText = "All Mountains are Plains";
            this.dependendToTypes.add(DependencyType.BecomeForest);
            this.dependendToTypes.add(DependencyType.BecomeIsland);
            this.dependendToTypes.add(DependencyType.BecomeMountain);
            this.dependendToTypes.add(DependencyType.BecomePlains);
            this.dependendToTypes.add(DependencyType.BecomeSwamp);
            this.dependencyTypes.add(DependencyType.BecomePlains);
        }

        private GlaciersEffect(GlaciersEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public boolean apply(Game game, Ability source) {
            return false;
        }

        public GlaciersEffect copy() {
            return new GlaciersEffect(this);
        }

        public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
            for (Permanent land : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
                switch (layer) {
                    case TypeChangingEffects_4: {
                        if (!land.hasSubtype(SubType.MOUNTAIN, game)) break;
                        land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                        land.addSubType(game, new SubType[]{SubType.PLAINS});
                        land.removeAllAbilities(source.getSourceId(), game);
                        land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                    }
                }
            }
            return true;
        }

        public boolean hasLayer(Layer layer) {
            return layer == Layer.TypeChangingEffects_4;
        }

        public Set<UUID> isDependentTo(List<ContinuousEffect> allEffectsInLayer) {
            return allEffectsInLayer.stream().filter(effect -> effect.getDependencyTypes().contains(DependencyType.BecomeMountain)).map(Effect::getId).collect(Collectors.toSet());
        }
    }
}

