/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GlamerSpinnersEffect
extends OneShotEffect {
    GlamerSpinnersEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "attach all Auras enchanting target permanent to another permanent with the same controller";
    }

    private GlamerSpinnersEffect(GlamerSpinnersEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlamerSpinnersEffect copy() {
        return new GlamerSpinnersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent;
        block7: {
            block6: {
                targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (targetPermanent == null) break block6;
                if (!targetPermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).noneMatch(p -> p.hasSubtype(SubType.AURA, game))) break block7;
            }
            return false;
        }
        FilterPermanent filter = new FilterPermanent("permanent" + Optional.ofNullable(targetPermanent).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getName).map(s -> " controlled by" + s).orElse(""));
        filter.add((Predicate)new ControllerIdPredicate(targetPermanent.getControllerId()));
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(targetPermanent.getId())));
        if (!game.getBattlefield().contains(filter, source.getControllerId(), source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.choose(this.outcome, (Target)target, source, game));
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        for (UUID attachmentId : targetPermanent.getAttachments()) {
            permanent.addAttachment(attachmentId, source, game);
        }
        return true;
    }
}

