/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;

class GlimpseOfTomorrowEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    GlimpseOfTomorrowEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle all permanents you own into your library, then reveal that many cards from the top of your library. Put all non-Aura permanent cards revealed this way onto the battlefield, then do the same for Aura cards, then put the rest on the bottom of your library in a random order";
    }

    private GlimpseOfTomorrowEffect(GlimpseOfTomorrowEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlimpseOfTomorrowEffect copy() {
        return new GlimpseOfTomorrowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        int count = permanents.size();
        player.shuffleCardsToLibrary((Cards)new CardsImpl(permanents), game, source);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, count));
        player.revealCards(source, (Cards)cards, game);
        CardsImpl toBattlefield = new CardsImpl(cards.getCards((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game));
        toBattlefield.removeIf(uuid -> game.getCard(uuid).hasSubtype(SubType.AURA, game));
        player.moveCards((Cards)toBattlefield, Zone.BATTLEFIELD, source, game);
        toBattlefield.clear();
        cards.retainZone(Zone.LIBRARY, game);
        toBattlefield.addAllCards((Collection)cards.getCards((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game));
        toBattlefield.removeIf(uuid -> !game.getCard(uuid).hasSubtype(SubType.AURA, game));
        player.moveCards((Cards)toBattlefield, Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

