/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class GlobalRuinDestroyLandEffect
extends OneShotEffect {
    GlobalRuinDestroyLandEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player chooses from the lands they control a land of each basic land type, then sacrifices the rest";
    }

    private GlobalRuinDestroyLandEffect(GlobalRuinDestroyLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlobalRuinDestroyLandEffect copy() {
        return new GlobalRuinDestroyLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> lands = new HashSet<UUID>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (SubType landName : Arrays.stream(SubType.values()).filter(p -> p.getSubTypeSet() == SubTypeSet.BasicLandType).collect(Collectors.toSet())) {
                FilterControlledLandPermanent filter = new FilterControlledLandPermanent(landName + " you control");
                filter.add((Predicate)landName.getPredicate());
                TargetControlledPermanent target = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)filter, true);
                if (!target.canChoose(player.getId(), source, game)) continue;
                player.chooseTarget(this.outcome, (Target)target, source, game);
                lands.add(target.getFirstTarget());
            }
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
            if (lands.contains(permanent.getId())) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

