/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GloomSowerEffect
extends OneShotEffect {
    GloomSowerEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that creature's controller loses 2 life";
    }

    private GloomSowerEffect(GloomSowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GloomSowerEffect copy() {
        return new GloomSowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        player.loseLife(2, game, source, false);
        return true;
    }
}

