/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;

class GloomSurgeonEffect
extends ReplacementEffectImpl {
    GloomSurgeonEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If combat damage would be dealt to {this}, prevent that damage and exile that many cards from the top of your library";
    }

    private GloomSurgeonEffect(GloomSurgeonEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        game.preventDamage(event, source, game, Integer.MAX_VALUE);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.moveCards(player.getLibrary().getTopCards(game, damage), Zone.EXILED, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId())) {
            DamageEvent damageEvent = (DamageEvent)event;
            return damageEvent.isCombatDamage();
        }
        return false;
    }

    public GloomSurgeonEffect copy() {
        return new GloomSurgeonEffect(this);
    }
}

