/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class GloriousProtectorEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("non-Angel creatures you control");

    GloriousProtectorEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of non-Angel creatures you control until {this} leaves the battlefield";
    }

    private GloriousProtectorEffect(GloriousProtectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public GloriousProtectorEffect copy() {
        return new GloriousProtectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        player.moveCardsToExile(new CardsImpl((Collection)target.getTargets()).getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), sourceObject.getIdName());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.ANGEL.getPredicate()));
    }
}

