/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GlowsporeShamanEffect
extends OneShotEffect {
    public static final FilterLandCard filter = new FilterLandCard("a land card from your graveyard");

    public GlowsporeShamanEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a land card from your graveyard on top of your library.";
    }

    private GlowsporeShamanEffect(GlowsporeShamanEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlowsporeShamanEffect copy() {
        return new GlowsporeShamanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)filter, true);
        if (player.chooseUse(this.outcome, "Put a land card on top of your library?", source, game) && player.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            return player.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, false);
        }
        return true;
    }
}

