/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetControlledCreaturePermanent;

class GluntchTheBestowerEffect
extends OneShotEffect {
    GluntchTheBestowerEffect() {
        super(Outcome.Neutral);
        this.setText("choose a player. They put two +1/+1 counters on a creature they control. Choose a second player to draw a card. Then choose a third player to create two Treasure tokens.");
    }

    private GluntchTheBestowerEffect(GluntchTheBestowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GluntchTheBestowerEffect copy() {
        return new GluntchTheBestowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPlayer playerChoice = new TargetPlayer();
        playerChoice.withNotTarget(true);
        playerChoice.withTargetName("a player that will put two +1/+1 counters on a creature they control");
        controller.choose(Outcome.BoostCreature, (Target)playerChoice, source, game);
        UUID firstChosenPlayerId = playerChoice.getFirstTarget();
        Player firstChosenPlayer = game.getPlayer(firstChosenPlayerId);
        if (firstChosenPlayerId == null || firstChosenPlayer == null) {
            return false;
        }
        game.informPlayers(firstChosenPlayer.getLogName() + " has been chosen for the first effect.");
        TargetControlledCreaturePermanent targetChosenCreature = new TargetControlledCreaturePermanent();
        targetChosenCreature.withNotTarget(true);
        playerChoice.withTargetName("a creature you control to add two +1/+1 counters on it");
        firstChosenPlayer.choose(Outcome.BoostCreature, (Target)targetChosenCreature, source, game);
        Permanent chosenCreature = game.getPermanent(targetChosenCreature.getFirstTarget());
        if (chosenCreature != null) {
            chosenCreature.addCounters(CounterType.P1P1.createInstance(2), firstChosenPlayerId, source, game);
        }
        FilterPlayer filterNotFirst = new FilterPlayer();
        filterNotFirst.add(Predicates.not((Predicate)new PlayerIdPredicate(firstChosenPlayerId)));
        playerChoice = new TargetPlayer(filterNotFirst);
        playerChoice.withNotTarget(true);
        playerChoice.withTargetName("a player that will draw a card");
        controller.choose(Outcome.DrawCard, (Target)playerChoice, source, game);
        UUID secondChosenPlayerId = playerChoice.getFirstTarget();
        Player secondChosenPlayer = game.getPlayer(secondChosenPlayerId);
        if (secondChosenPlayerId == null || secondChosenPlayer == null) {
            return true;
        }
        game.informPlayers(secondChosenPlayer.getLogName() + " has been chosen for the second effect.");
        secondChosenPlayer.drawCards(1, source, game);
        FilterPlayer filterNotFirstNorSecond = new FilterPlayer();
        filterNotFirstNorSecond.add(Predicates.not((Predicate)new PlayerIdPredicate(firstChosenPlayerId)));
        filterNotFirstNorSecond.add(Predicates.not((Predicate)new PlayerIdPredicate(secondChosenPlayerId)));
        playerChoice = new TargetPlayer(filterNotFirstNorSecond);
        playerChoice.withNotTarget(true);
        playerChoice.withTargetName("a player that will create two Treasure tokens");
        controller.choose(Outcome.DrawCard, (Target)playerChoice, source, game);
        UUID thirdChosenPlayerId = playerChoice.getFirstTarget();
        Player thirdChosenPlayer = game.getPlayer(thirdChosenPlayerId);
        if (thirdChosenPlayerId == null || thirdChosenPlayer == null) {
            return true;
        }
        game.informPlayers(thirdChosenPlayer.getLogName() + " has been chosen for the third effect.");
        new TreasureToken().putOntoBattlefield(2, game, source, thirdChosenPlayerId);
        return true;
    }
}

