/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.BlockedAttackerWatcher;

class GlyphOfDoomEffect
extends OneShotEffect {
    MageObjectReference targetCreature;

    public GlyphOfDoomEffect(MageObjectReference targetCreature) {
        super(Outcome.DestroyPermanent);
        this.targetCreature = targetCreature;
    }

    private GlyphOfDoomEffect(GlyphOfDoomEffect effect) {
        super((OneShotEffect)effect);
        this.targetCreature = effect.targetCreature;
    }

    public GlyphOfDoomEffect copy() {
        return new GlyphOfDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        BlockedAttackerWatcher watcher;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && this.targetCreature != null && (watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class)) != null) {
            ArrayList<Permanent> toDestroy = new ArrayList<Permanent>();
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (creature.getId().equals(this.targetCreature.getSourceId()) || !watcher.creatureHasBlockedAttacker(new MageObjectReference((MageObject)creature, game), this.targetCreature)) continue;
                toDestroy.add(creature);
            }
            for (Permanent creature : toDestroy) {
                creature.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

