/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.watchers.common.BlockedAttackerWatcher;

class GlyphOfReincarnationEffect
extends OneShotEffect {
    GlyphOfReincarnationEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures that were blocked by target Wall this turn. They can't be regenerated. For each creature that died this way, put a creature card from the graveyard of the player who controlled that creature the last time it became blocked by that Wall onto the battlefield under its owner's control";
    }

    private GlyphOfReincarnationEffect(GlyphOfReincarnationEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlyphOfReincarnationEffect copy() {
        return new GlyphOfReincarnationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        BlockedAttackerWatcher watcher;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetWall = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && targetWall != null && (watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class)) != null) {
            HashMap<UUID, Player> destroyed = new HashMap<UUID, Player>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                Player permController;
                if (permanent.getId().equals(targetWall.getId()) || !watcher.creatureHasBlockedAttacker(new MageObjectReference((MageObject)permanent, game), new MageObjectReference((MageObject)targetWall, game)) || !permanent.destroy(source, game, true) || game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD || (permController = game.getPlayer(permanent.getControllerId())) == null) continue;
                destroyed.put(permanent.getId(), permController);
            }
            game.processAction();
            for (Map.Entry entry : destroyed.entrySet()) {
                Card card;
                Permanent permanent = (Permanent)game.getLastKnownInformation((UUID)entry.getKey(), Zone.BATTLEFIELD);
                Player player = (Player)entry.getValue();
                if (permanent == null || player == null) continue;
                FilterCreatureCard filter = new FilterCreatureCard("a creature card from " + player.getName() + "'s graveyard");
                filter.add((Predicate)new OwnerIdPredicate(player.getId()));
                TargetCardInGraveyard targetCreature = new TargetCardInGraveyard((FilterCard)filter);
                targetCreature.withNotTarget(true);
                if (!targetCreature.canChoose(controller.getId(), source, game) || !controller.chooseTarget(this.outcome, (Target)targetCreature, source, game) || (card = game.getCard(targetCreature.getFirstTarget())) == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) continue;
                controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
            return true;
        }
        return false;
    }
}

