/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class GoToJailExileEffect
extends OneShotEffect {
    GoToJailExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature an opponent controls until {this} leaves the battlefield.";
    }

    private GoToJailExileEffect(GoToJailExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoToJailExileEffect copy() {
        return new GoToJailExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && targetPermanent != null && (controller = game.getPlayer(targetPermanent.getControllerId())) != null) {
            game.getState().setValue(permanent.getId() + "_opponent", (Object)controller.getId());
            new ExileTargetEffect(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), permanent.getIdName()).apply(game, source);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
            return true;
        }
        return false;
    }
}

