/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GoatnapEffect
extends OneShotEffect {
    GoatnapEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature is a Goat, it also gets +3/+0 until end of turn.";
    }

    private GoatnapEffect(GoatnapEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoatnapEffect copy() {
        return new GoatnapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || !permanent.hasSubtype(SubType.GOAT, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(3, 0, Duration.EndOfTurn), source);
        return true;
    }
}

