/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Iterator;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinCharbelcherEffect
extends OneShotEffect {
    GoblinCharbelcherEffect() {
        super(Outcome.Damage);
        this.staticText = "Reveal cards from the top of your library until you reveal a land card. {this} deals damage equal to the number of nonland cards revealed this way to any target. If the revealed land card was a Mountain, {this} deals double that damage instead. Put the revealed cards on the bottom of your library in any order";
    }

    private GoblinCharbelcherEffect(GoblinCharbelcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinCharbelcherEffect copy() {
        return new GoblinCharbelcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Card card;
        boolean isMountain = false;
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        boolean landFound = false;
        Iterator iterator = controller.getLibrary().getCards(game).iterator();
        while (iterator.hasNext() && (card = (Card)iterator.next()) != null) {
            cards.add(card);
            if (!card.isLand(game)) continue;
            landFound = true;
            if (!card.hasSubtype(SubType.MOUNTAIN, game)) break;
            isMountain = true;
            break;
        }
        controller.revealCards(sourceObject.getName(), (Cards)cards, game);
        int damage = cards.size();
        if (landFound) {
            --damage;
        }
        if (isMountain) {
            damage *= 2;
        }
        if ((permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            permanent.damage(damage, source.getSourceId(), source, game, false, true);
        } else {
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (targetPlayer != null) {
                targetPlayer.damage(damage, source.getSourceId(), source, game);
            }
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

