/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GoblinFurrierPreventEffectEffect
extends PreventionEffectImpl {
    GoblinFurrierPreventEffectEffect(Duration duration) {
        super(duration, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that {this} would deal to snow creatures";
    }

    private GoblinFurrierPreventEffectEffect(GoblinFurrierPreventEffectEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public GoblinFurrierPreventEffectEffect copy() {
        return new GoblinFurrierPreventEffectEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event.getSourceId().equals(source.getSourceId())) {
            Permanent damageTo = game.getPermanent(event.getTargetId());
            return damageTo != null && damageTo.isSnow(game);
        }
        return false;
    }
}

