/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GoblinGameEffect
extends OneShotEffect {
    GoblinGameEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player hides at least one item, then all players reveal them simultaneously. Each player loses life equal to the number of items they revealed. The player who revealed the fewest items then loses half their life, rounded up. If two or more players are tied for fewest, each loses half their life, rounded up.";
    }

    private GoblinGameEffect(GoblinGameEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinGameEffect copy() {
        return new GoblinGameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> numberChosen = new HashMap<UUID, Integer>();
        List players = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Player player : players) {
            numberChosen.put(player.getId(), player.getAmount(1, 1000, "Choose a number of objects to hide.", source, game));
        }
        int lowestNumber = numberChosen.values().stream().mapToInt(x -> x).min().orElse(0);
        for (Player player : players) {
            game.informPlayers(player.getLogName() + " chose " + numberChosen.get(player.getId()));
            player.loseLife(((Integer)numberChosen.get(player.getId())).intValue(), game, source, false);
        }
        for (Player player : players) {
            if ((Integer)numberChosen.get(player.getId()) > lowestNumber) continue;
            game.informPlayers(player.getLogName() + " chose the lowest number");
            Integer amount = (int)Math.ceil((float)player.getLife() / 2.0f);
            if (amount <= 0) continue;
            player.loseLife(amount.intValue(), game, source, false);
        }
        return true;
    }
}

