/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.FlipCoinEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GoblinKites
extends CardImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature you control with toughness 2 or less");

    public GoblinKites(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), (Cost)new ManaCostsImpl("{R}"));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        OneShotEffect effect = new FlipCoinEffect(null, (Effect)new SacrificeTargetEffect().setText("sacrifice that creature")).setText("Flip a coin at the beginning of the next end step. If you lose the flip, sacrifice that creature");
        ability.addEffect((Effect)new CreateDelayedTriggeredAbilityEffect(new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect).setTriggerPhrase("")));
        this.addAbility((Ability)ability);
    }

    private GoblinKites(GoblinKites card) {
        super((CardImpl)card);
    }

    public GoblinKites copy() {
        return new GoblinKites(this);
    }

    static {
        filter.add((Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, 3));
    }
}

