/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GoblinToken;
import mage.util.CardUtil;

class GoblinNegotiationEffect
extends OneShotEffect {
    GoblinNegotiationEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to target creature. Create a number of 1/1 red Goblin creature tokens equal to the amount of excess damage dealt to that creature this way";
    }

    private GoblinNegotiationEffect(GoblinNegotiationEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinNegotiationEffect copy() {
        return new GoblinNegotiationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game);
        if (excess > 0) {
            new GoblinToken().putOntoBattlefield(excess, game, source);
        }
        return true;
    }
}

