/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;

class GoblinPsychopathEffect
extends ReplacementEffectImpl {
    private boolean wonFlip;

    public GoblinPsychopathEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "flip a coin. If you lose the flip, the next time it would deal combat damage this turn, it deals that damage to you instead";
    }

    private GoblinPsychopathEffect(GoblinPsychopathEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            this.discard();
            return;
        }
        this.wonFlip = controller.flipCoin(source, game, true);
    }

    public GoblinPsychopathEffect copy() {
        return new GoblinPsychopathEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            game.informPlayers("Couldn't find source of damage");
            return false;
        }
        return event.getSourceId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || object == null || !this.applies(event, source, game) || !(event instanceof DamageEvent) || event.getAmount() <= 0) {
            return false;
        }
        DamageEvent damageEvent = (DamageEvent)event;
        if (!damageEvent.isCombatDamage() || this.wonFlip) {
            return false;
        }
        controller.damage(event.getAmount(), source.getSourceId(), source, game);
        String sourceLogName = game.getObject(source).getLogName() + ": ";
        game.informPlayers(sourceLogName + "Redirected " + event.getAmount() + " damage to " + controller.getLogName());
        this.discard();
        return true;
    }
}

