/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.g.EnchantedPermanentSubtypeCondition;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;

public final class GoblinShrine
extends CardImpl {
    private static final FilterCreaturePermanent filterGoblin = new FilterCreaturePermanent("Goblin creature");
    private static final String rule = "As long as enchanted land is a basic Mountain, Goblin creatures get +1/+0.";

    public GoblinShrine(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetLandPermanent auraTarget = new TargetLandPermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ConditionalContinuousEffect effect = new ConditionalContinuousEffect((ContinuousEffect)new BoostAllEffect(1, 0, Duration.WhileOnBattlefield, filterGoblin, false), (Condition)new EnchantedPermanentSubtypeCondition(SubType.MOUNTAIN), rule);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
        this.addAbility((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new DamageAllEffect(1, "it", (FilterPermanent)filterGoblin), false));
    }

    private GoblinShrine(GoblinShrine card) {
        super((CardImpl)card);
    }

    public GoblinShrine copy() {
        return new GoblinShrine(this);
    }

    static {
        filterGoblin.add((Predicate)SubType.GOBLIN.getPredicate());
    }
}

