/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GoblinWarCryRestrictionEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GoblinWarCryEffect
extends OneShotEffect {
    GoblinWarCryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent chooses a creature they control. Other creatures they control can't block this turn.";
    }

    private GoblinWarCryEffect(GoblinWarCryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinWarCryEffect copy() {
        return new GoblinWarCryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature you control");
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
        if (player.chooseTarget(Outcome.DestroyPermanent, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            game.informPlayers(player.getLogName() + " has chosen " + permanent.getLogName() + " as their only creature able to block this turn");
        }
        game.addEffect((ContinuousEffect)new GoblinWarCryRestrictionEffect(target.getFirstTarget()), source);
        return true;
    }
}

