/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetArtifactPermanent;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

public final class GoblinWelder
extends CardImpl {
    public GoblinWelder(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{R}");
        this.subtype.add((Object)SubType.GOBLIN);
        this.subtype.add((Object)SubType.ARTIFICER);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new GoblinWelderEffect(), (Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetArtifactPermanent());
        ability.addTarget((Target)new GoblinWelderTarget());
        this.addAbility((Ability)ability);
    }

    private GoblinWelder(GoblinWelder card) {
        super((CardImpl)card);
    }

    public GoblinWelder copy() {
        return new GoblinWelder(this);
    }

    private static class GoblinWelderTarget
    extends TargetCardInGraveyard {
        public GoblinWelderTarget() {
            super((FilterCard)new FilterArtifactCard());
            this.targetName = "target artifact card in that player's graveyard";
        }

        private GoblinWelderTarget(GoblinWelderTarget target) {
            super((TargetCardInGraveyard)target);
        }

        public boolean canTarget(UUID id, Ability source, Game game) {
            Permanent permanent = game.getPermanent(source.getFirstTarget());
            if (permanent == null) {
                return false;
            }
            Card card = game.getCard(id);
            return card != null && card.isArtifact(game) && card.isOwnedBy(permanent.getControllerId());
        }

        public GoblinWelderTarget copy() {
            return new GoblinWelderTarget(this);
        }
    }

    private static class GoblinWelderEffect
    extends OneShotEffect {
        public GoblinWelderEffect() {
            super(Outcome.PutCardInPlay);
            this.staticText = "Choose target artifact a player controls and target artifact card in that player's graveyard. If both targets are still legal as this ability resolves, that player simultaneously sacrifices the artifact and returns the artifact card to the battlefield";
            this.setTargetPointer((TargetPointer)new EachTargetPointer());
        }

        private GoblinWelderEffect(GoblinWelderEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            if (this.getTargetPointer().getTargets(game, source).size() < 2) {
                return false;
            }
            Permanent artifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Card card = game.getCard((UUID)this.getTargetPointer().getTargets(game, source).get(1));
            Player controller = game.getPlayer(source.getControllerId());
            if (artifact == null || card == null || controller == null) {
                return false;
            }
            Player owner = game.getPlayer(card.getOwnerId());
            if (owner == null) {
                return false;
            }
            boolean sacrifice = artifact.sacrifice(source, game);
            boolean putOnBF = owner.moveCards(card, Zone.BATTLEFIELD, source, game);
            return sacrifice || putOnBF;
        }

        public GoblinWelderEffect copy() {
            return new GoblinWelderEffect(this);
        }
    }
}

