/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Arrays;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.util.functions.CopyApplier;

class GogoMysteriousMimeEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
            blueprint.setName("Gogo, Mysterious Mime");
            return true;
        }
    };

    GogoMysteriousMimeEffect() {
        super(Outcome.Benefit);
        this.staticText = "have {this} become a copy of another target creature you control until end of turn, except its name is Gogo, Mysterious Mime. If you do, {this} and that creature each get +2/+0 and gain haste until end of turn and attack this turn if able";
    }

    private GogoMysteriousMimeEffect(GogoMysteriousMimeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GogoMysteriousMimeEffect copy() {
        return new GogoMysteriousMimeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || permanent == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, permanent, sourcePermanent.getId(), source, applier);
        FixedTargets targetPointer = new FixedTargets(Arrays.asList(sourcePermanent, permanent), game);
        game.addEffect(new BoostTargetEffect(2, 0).setTargetPointer(targetPointer.copy()), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer(targetPointer.copy()), source);
        game.addEffect(new AttacksIfAbleTargetEffect(Duration.EndOfTurn).setTargetPointer(targetPointer.copy()), source);
        return true;
    }
}

