/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoldberryRiverDaughterFromEffect
extends OneShotEffect {
    GoldberryRiverDaughterFromEffect() {
        super(Outcome.Neutral);
        this.staticText = "Move a counter of each kind not on {this} from another target permanent you control onto Goldberry.";
    }

    private GoldberryRiverDaughterFromEffect(GoldberryRiverDaughterFromEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoldberryRiverDaughterFromEffect copy() {
        return new GoldberryRiverDaughterFromEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent fromPermanent = game.getPermanent(source.getFirstTarget());
        Permanent toPermanent = game.getPermanent(source.getSourceId());
        if (controller == null || fromPermanent == null || toPermanent == null) {
            return false;
        }
        HashSet fromCounters = new HashSet(fromPermanent.getCounters(game).keySet());
        fromCounters.removeAll(toPermanent.getCounters(game).keySet());
        if (fromCounters.size() == 0) {
            return false;
        }
        for (String counter : fromCounters) {
            fromPermanent.removeCounters(counter, 1, source, game);
            toPermanent.addCounters(CounterType.findByName((String)counter).createInstance(1), source.getControllerId(), source, game);
        }
        return true;
    }
}

