/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class GoldbugScrappyScoutTriggeredAbility
extends TriggeredAbilityImpl {
    GoldbugScrappyScoutTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addEffect((Effect)new TransformSourceEffect());
    }

    private GoldbugScrappyScoutTriggeredAbility(GoldbugScrappyScoutTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GoldbugScrappyScoutTriggeredAbility copy() {
        return new GoldbugScrappyScoutTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) return false;
        if (!game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.HUMAN, game))) return false;
        return true;
    }

    public String getRule() {
        return "Whenever {this} and at least one Human attack, draw a card and convert {this}.";
    }
}

