/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.CrewedVehicleWatcher;

class GoldenArgosyEffect
extends OneShotEffect {
    GoldenArgosyEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile each creature that crewed it this turn. Return them to the battlefield tapped under their owner's control at the beginning of the next end step";
    }

    private GoldenArgosyEffect(GoldenArgosyEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoldenArgosyEffect copy() {
        return new GoldenArgosyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent vehicle = game.getPermanent(source.getSourceId());
        if (player == null || vehicle == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(CrewedVehicleWatcher.getCrewers((Permanent)vehicle, (Game)game));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnToBattlefieldUnderOwnerControlTargetEffect(true, false).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)).setText("return them to the battlefield tapped")), source);
        return true;
    }
}

