/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GolgariGraveTrollEffect
extends OneShotEffect {
    GolgariGraveTrollEffect() {
        super(Outcome.BoostCreature);
    }

    private GolgariGraveTrollEffect(GolgariGraveTrollEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && player != null) {
            int amount = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            if (amount > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public GolgariGraveTrollEffect copy() {
        return new GolgariGraveTrollEffect(this);
    }
}

