/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GollumObsessedStalkerWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PlayerGainedLifeWatcher;

class GollumObsessedStalkerEffect
extends OneShotEffect {
    GollumObsessedStalkerEffect() {
        super(Outcome.LoseLife);
        this.staticText = "each opponent dealt combat damage this game by a creature named Gollum, Obsessed Stalker loses life equal to the amount of life you gained this turn.";
    }

    private GollumObsessedStalkerEffect(GollumObsessedStalkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GollumObsessedStalkerEffect copy() {
        return new GollumObsessedStalkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        GollumObsessedStalkerWatcher damageWatcher = (GollumObsessedStalkerWatcher)game.getState().getWatcher(GollumObsessedStalkerWatcher.class);
        PlayerGainedLifeWatcher lifeWatcher = (PlayerGainedLifeWatcher)game.getState().getWatcher(PlayerGainedLifeWatcher.class);
        Permanent gollum = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (damageWatcher == null || lifeWatcher == null || gollum == null) {
            return false;
        }
        int amount = lifeWatcher.getLifeGained(source.getControllerId());
        Set<UUID> playersDamaged = damageWatcher.getPlayersDamaged();
        if (amount == 0 || playersDamaged.isEmpty()) {
            return true;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player;
            if (!playersDamaged.contains(playerId) || (player = game.getPlayer(playerId)) == null) continue;
            player.loseLife(amount, game, source, false);
        }
        return true;
    }
}

