/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class GollumObsessedStalkerWatcher
extends Watcher {
    private final Set<UUID> playersGollumDamaged = new HashSet<UUID>();

    public GollumObsessedStalkerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER || !((DamagedPlayerEvent)event).isCombatDamage()) {
            return;
        }
        Permanent creature = game.getPermanent(event.getSourceId());
        if (creature == null) {
            return;
        }
        UUID playerId = event.getPlayerId();
        if (creature.getName().equals("Gollum, Obsessed Stalker") && playerId != null) {
            this.playersGollumDamaged.add(playerId);
        }
    }

    public Set<UUID> getPlayersDamaged() {
        return this.playersGollumDamaged;
    }
}

