/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

class GolosTirelessPilgrimEffect
extends OneShotEffect {
    GolosTirelessPilgrimEffect() {
        super(Outcome.Discard);
        this.staticText = "Exile the top three cards of your library. You may play them this turn without paying their mana costs.";
    }

    private GolosTirelessPilgrimEffect(GolosTirelessPilgrimEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = player.getLibrary().getTopCards(game, 3);
        return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Set)cards, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)true, (boolean)false, (boolean)false);
    }

    public GolosTirelessPilgrimEffect copy() {
        return new GolosTirelessPilgrimEffect(this);
    }
}

