/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.MayLookAtTargetCardEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GontiExileEffect
extends OneShotEffect {
    GontiExileEffect() {
        super(Outcome.Exile);
        this.staticText = "its controller looks at the top card of that opponent's library and exiles it face down. They may play that card for as long as it remains exiled. Mana of any type can be spent to cast a spell this way.";
    }

    private GontiExileEffect(GontiExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public GontiExileEffect copy() {
        return new GontiExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String exileName;
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer((UUID)((Effect)source.getEffects().get(0)).getValue("controllerId"));
        if (targetOpponent == null || controller == null) {
            return false;
        }
        Card card = targetOpponent.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)controller.getId(), (int)source.getStackMomentSourceZCC());
        if (controller.moveCardsToExile(card, source, game, false, exileZoneId, exileName = CardUtil.getSourceName((Game)game, (Ability)source) + " - " + controller.getName())) {
            card.setFaceDown(true, game);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)true, (UUID)controller.getId(), null);
        }
        MayLookAtTargetCardEffect effect = new MayLookAtTargetCardEffect(controller.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

