/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.token.FoodAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GourmandsTalentEffect
extends ContinuousEffectImpl {
    GourmandsTalentEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Other creatures are Food artifacts in addition to their other types and have \"{2}, {T}, Sacrifice this permanent: You gain 3 life.\"";
        this.dependencyTypes.add(DependencyType.AddingAbility);
    }

    private GourmandsTalentEffect(GourmandsTalentEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GourmandsTalentEffect copy() {
        return new GourmandsTalentEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT, source.getControllerId(), source, game)) {
            if (permanent.getId().equals(source.getSourceId())) continue;
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.FOOD});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)new FoodAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

