/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GrandMasterOfFlowersEffect
extends ContinuousEffectImpl {
    GrandMasterOfFlowersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as long as {this} has seven or more loyalty counters on him, he's a 7/7 Dragon God creature with flying and indestructible";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private GrandMasterOfFlowersEffect(GrandMasterOfFlowersEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GrandMasterOfFlowersEffect copy() {
        return new GrandMasterOfFlowersEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.LOYALTY) < 7) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.removeAllSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.DRAGON});
                permanent.addSubType(game, new SubType[]{SubType.GOD});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                permanent.addAbility((Ability)IndestructibleAbility.getInstance(), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(7);
                permanent.getToughness().setModifiedBaseValue(7);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

