/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GrandMoffTarkinEffect
extends OneShotEffect {
    GrandMoffTarkinEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "destroy target creature that that player controls unless that player pays 2 life. If a player pays life this way, draw a card";
    }

    private GrandMoffTarkinEffect(GrandMoffTarkinEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrandMoffTarkinEffect copy() {
        return new GrandMoffTarkinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature == null) {
            return false;
        }
        Player player = game.getPlayer(targetCreature.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.getLife() > 2 && player.chooseUse(Outcome.Neutral, "Pay 2 life? If you don't, " + targetCreature.getName() + " will be destroyed", source, game)) {
            player.loseLife(2, game, source, false);
            game.informPlayers(player.getLogName() + " pays 2 life to prevent " + targetCreature.getName() + " being destroyed");
            Player sourceController = game.getPlayer(source.getControllerId());
            if (sourceController != null) {
                sourceController.drawCards(1, source, game);
            }
            return true;
        }
        targetCreature.destroy(source, game, false);
        return true;
    }
}

