/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class GraspingTentaclesEffect
extends OneShotEffect {
    GraspingTentaclesEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put an artifact card from that player's graveyard onto the battlefield under your control";
    }

    private GraspingTentaclesEffect(GraspingTentaclesEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraspingTentaclesEffect copy() {
        return new GraspingTentaclesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, true);
        controller.choose(Outcome.PutCardInPlay, (Cards)opponent.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

