/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GraveConsequencesEffect
extends OneShotEffect {
    GraveConsequencesEffect() {
        super(Outcome.Exile);
        this.staticText = "each player may exile any number of cards from their graveyard. Then each player loses 1 life for each card in their graveyard";
    }

    private GraveConsequencesEffect(GraveConsequencesEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveConsequencesEffect copy() {
        return new GraveConsequencesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List players = game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Player player : players) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, Integer.MAX_VALUE);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            if (cards.isEmpty()) continue;
            player.moveCards((Cards)cards, Zone.EXILED, source, game);
        }
        for (Player player : players) {
            if (player.getGraveyard().isEmpty()) continue;
            player.loseLife(player.getLife(), game, source, false);
        }
        return true;
    }
}

