/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GraveSifterEffect
extends OneShotEffect {
    GraveSifterEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "each player chooses a creature type and returns any number of cards of that type from their graveyard to their hand";
    }

    private GraveSifterEffect(GraveSifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveSifterEffect copy() {
        return new GraveSifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        typeChoice.setMessage("Choose creature type to return cards from your graveyard");
        Player controller = game.getPlayer(source.getControllerId());
        HashSet toHand = new HashSet();
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                typeChoice.clearChoice();
                if (!player.choose(this.outcome, (Choice)typeChoice, game)) continue;
                game.informPlayers(player.getLogName() + " has chosen: " + typeChoice.getChoiceKey());
                FilterCreatureCard filter = new FilterCreatureCard("creature cards with creature type " + typeChoice.getChoiceKey() + " from your graveyard");
                filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, Integer.MAX_VALUE, (FilterCard)filter);
                player.chooseTarget(this.outcome, (Target)target, source, game);
                toHand.addAll(new CardsImpl((Collection)target.getTargets()).getCards(game));
            }
            controller.moveCards(toHand, Zone.HAND, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

