/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GravebaneZombieEffect
extends ReplacementEffectImpl {
    GravebaneZombieEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "If {this} would die, put {this} on top of its owner's library instead";
    }

    private GravebaneZombieEffect(GravebaneZombieEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            return controller.putCardsOnTopOfLibrary((Card)permanent, game, source, true);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId()) && ((ZoneChangeEvent)event).isDiesEvent();
    }

    public GravebaneZombieEffect copy() {
        return new GravebaneZombieEffect(this);
    }
}

